unit [!UnitName];

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Diagnostics, System.Web,
  System.Web.Services,
  Borland.Eco.ObjectRepresentation, 
[!if=(EcoSpaceUnitName, "<NONE>")]
  Borland.Eco.Handles;
[!else]
  Borland.Eco.Handles, [!EcoSpaceUnitName], [!EcoPackageUnitName];
[!endif]

type
  T[!ClassName] = class(System.Web.Services.WebService)
  {$REGION 'Designer Managed Code'}
  strict private
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: IContainer;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    fEcoSpace: [!EcoSpaceClassName];
    function get_EcoSpace: [!EcoSpaceClassName];
    procedure DoneWithEcoSpace;
    property EcoSpace: [!EcoSpaceClassName] read get_EcoSpace;
  strict protected
    procedure Dispose(disposing: boolean); override;
  {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObjectInstance;
  {$ENDREGION}
  public
    constructor Create;
    (*
    // Sample Web Service Method
    [WebMethod]
    function HelloWorld: string;
    [WebMethod]
    function OrderCount: integer;
    [WebMethod]
    procedure NewOrder(Name: String);
    *)
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure T[!ClassName].InitializeComponent;
begin    
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  //
  // rhRoot
  //
  Self.rhRoot.EcoSpace := nil;
[!if=(EcoSpaceUnitName, "<NONE>")]
[!else]
  Self.rhRoot.EcoSpaceType := TypeOf([!EcoSpaceUnitName].[!EcoSpaceClassName]);
[!endif]
  Self.rhRoot.StaticValueTypeName := '';
  Self.rhRoot.Variables := nil;
end;
{$ENDREGION}

constructor T[!ClassName].Create;
begin
  inherited;
  //
  // Required for Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

{$REGION 'Utility Methods'}
procedure T[!ClassName].UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function T[!ClassName].IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function T[!ClassName].ObjectForId(Id: string): IObjectInstance;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

procedure T[!ClassName].Dispose(disposing: boolean);
begin
  if disposing and (components <> nil) then
    components.Dispose;
  inherited Dispose(disposing);
end;

function T[!ClassName].get_EcoSpace: [!EcoSpaceClassName];
begin
  if not Assigned(fEcoSpace) then
  begin
    fecoSpace := TEcoSpaceProvider.GetSessionFreeEcoSpace;
    rhRoot.EcoSpace := fEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure T[!ClassName].DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or it's contents here.
  // Otherwise it is not safe to return it to a pool

  TEcoSpaceProvider.ReturnSessionFreeEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

(*
// Sample Web Service Methods
// The following method is provided to allow for testing a new web service.
function TWebService1.HelloWorld: string;
begin
  Result := 'Hello World';
end;

// This is a minimal web method reading data,
// It assumes an ECO model containing a Class named Order
function TWebService1.OrderCount: integer;
var
  OclService: IOclService;
  ResultElement: IElement;
begin
  OclService := EcoSpace.GetEcoService(typeof(IOclService)) as IOclService;
  ResultElement := OclService.EvaluateAndSubscribe(nil, 'Order.allInstances->size', nil, nil);
  Result := Integer(ResultElement.AsObject);
  DoneWithEcoSpace;
end;

// This is a minimal web method modifying data
// It assumes an ECO model containing a Class named Order with an attribute Order.CustomerName
procedure TWebService1.NewOrder(Name: String);
var
  anOrder: Order;
begin
  anOrder := Order.Create(EcoSpace);
  anOrder.CustomerName := Name;
  UpdateDatabase;
  DoneWithEcoSpace;
end;
 *)

end.

